# Document Features Setup & Troubleshooting Guide

## Quick Start (3 Steps)

### Step 1: Verify Database Setup
Visit: http://localhost/Claude/test-document-features.php

This page will check:
- ✅ document_notes column exists
- ✅ project_urls table exists
- ✅ All API files exist
- ✅ All JavaScript files exist

### Step 2: Run Setup (if needed)
If test page shows missing items:
Visit: http://localhost/Claude/setup-documents.php
Click "Run Setup"

### Step 3: Test the Features
1. Go to Dashboard: http://localhost/Claude/dashboard.php
2. Click on any project (or create a new one)
3. Click "Documents" tab
4. You should see 3 sections: Notes, URLs, Files

## Common Issues & Solutions

### Issue 1: "Cannot save notes"

**Symptoms:**
- Click "Save Notes" button
- Nothing happens or error message

**Solution:**
1. Open browser console (F12) → Console tab
2. Look for JavaScript errors
3. Check if `PROJECT_ID` is defined:
   - In console, type: `PROJECT_ID`
   - Should show a number (project ID)

4. Test API manually:
   - Open: http://localhost/Claude/api/projects/update-notes.php
   - Should show: "Unauthorized" or "Method not allowed" (this is normal - means API exists)

### Issue 2: "Cannot add URLs"

**Symptoms:**
- Click "Add URL" button
- Modal doesn't open, or save doesn't work

**Solution:**
1. Check browser console for errors
2. Verify table exists:
   - Visit: http://localhost/Claude/test-document-features.php
   - Look for "project_urls Table" section

3. Test API:
   - Open: http://localhost/Claude/api/urls/create.php
   - Should show error (normal - means file exists)

### Issue 3: "JavaScript functions not defined"

**Symptoms:**
- Console shows: "saveNotes is not a function" or "saveUrl is not defined"

**Solution:**
1. Check if JavaScript file is loaded:
   - In browser, open project page
   - Press F12 → Network tab
   - Reload page
   - Look for: `project-notes-urls.js`
   - Should show status 200

2. If file not found (404):
   - Verify file exists at: `Claude/assets/js/project-notes-urls.js`
   - Check file permissions

### Issue 4: "Database column not found"

**Error in log:**
```
SQLSTATE[42S22]: Column not found: 1054 Unknown column 'document_notes' in 'field list'
```

**Solution:**
Run this SQL in phpMyAdmin:
```sql
ALTER TABLE projects ADD COLUMN document_notes TEXT NULL AFTER description;
```

### Issue 5: "Table doesn't exist"

**Error:**
```
SQLSTATE[42S02]: Base table or view not found: 1146 Table 'project_manager.project_urls' doesn't exist
```

**Solution:**
Run this SQL in phpMyAdmin:
```sql
CREATE TABLE project_urls (
    id INT PRIMARY KEY AUTO_INCREMENT,
    project_id INT NOT NULL,
    title VARCHAR(200) NOT NULL,
    url VARCHAR(500) NOT NULL,
    description TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (project_id) REFERENCES projects(id) ON DELETE CASCADE,
    INDEX idx_project_id (project_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
```

## Testing Checklist

### ✅ Notes Feature
1. Go to any project → Documents tab
2. Type text in Notes textarea
3. Click "Save Notes"
4. Should see green success message
5. Refresh page - notes should still be there
6. Check Activity tab - should show "Updated document notes"

### ✅ URLs Feature
1. In Documents tab, click "Add URL" button
2. Modal should open
3. Enter:
   - Title: "Test Link"
   - URL: "https://google.com"
   - Description: "Testing URL feature"
4. Click "Add URL"
5. Should see green success message
6. URL should appear in the URLs section
7. Click the URL - should open in new tab
8. Click delete button - URL should be removed
9. Check Activity tab - should show "Added URL" and "Deleted URL"

### ✅ Files Feature (Already Working)
1. Choose a file (PDF, image, etc.)
2. Click "Upload Files"
3. Should see success message
4. File should appear in list
5. Download button should work
6. Delete button should work

## Debug Mode

If issues persist, check error log:
http://localhost/Claude/view-errors.php

Look for entries with:
- `/api/projects/update-notes.php`
- `/api/urls/create.php`
- `/api/urls/list.php`

## Browser Console Commands

Open console (F12) and type:

```javascript
// Check if PROJECT_ID is defined
console.log('Project ID:', PROJECT_ID);

// Check if functions are defined
console.log('saveNotes:', typeof saveNotes);
console.log('saveUrl:', typeof saveUrl);
console.log('loadDocumentNotes:', typeof loadDocumentNotes);
console.log('loadUrls:', typeof loadUrls);

// All should show 'function', not 'undefined'
```

## File Locations

All files should exist at these locations:

**PHP Files:**
- `Claude/api/projects/update-notes.php`
- `Claude/api/urls/create.php`
- `Claude/api/urls/list.php`
- `Claude/api/urls/delete.php`

**JavaScript:**
- `Claude/assets/js/project-notes-urls.js`

**Setup:**
- `Claude/setup-documents.php`
- `Claude/add-document-features.sql`

## Still Having Issues?

1. **Clear browser cache**: Ctrl+Shift+Delete
2. **Hard refresh**: Ctrl+F5
3. **Check permissions**: Ensure files are readable
4. **Verify MySQL**: Make sure MySQL is running in XAMPP
5. **Check error log**: http://localhost/Claude/view-errors.php

## Success Indicators

When everything works correctly:

✅ Notes save without errors
✅ URLs can be added and deleted
✅ Activity log shows all actions
✅ Browser console has no errors
✅ test-document-features.php shows all green checkmarks

---

**Need Help?**
Run: http://localhost/Claude/test-document-features.php
Check: http://localhost/Claude/view-errors.php
