# Project Manager - Web & Mobile Project Management Application

A responsive, mobile-friendly project management application built with PHP, MySQL, Bootstrap 5, and vanilla JavaScript. Perfect for managing projects, tasks, documents, and tracking progress on both web and mobile devices.

## Features

### Core Features
- **User Authentication**: Secure login and registration with password hashing
- **Project Management**: Create, update, delete, and track multiple projects
- **Task Management**: Add tasks to projects with status, priority, due dates, and notes
- **Document Management**: Upload, download, and manage project documents
- **Activity Logging**: Track all actions with a comprehensive activity log
- **Dashboard Analytics**: Visual statistics and charts showing project status

### Advanced Features
- **Search & Filter**: Find projects quickly with search and filter by status
- **Progress Tracking**: Visual progress bars showing task completion
- **Priority Levels**: High, medium, and low priority tasks
- **Due Date Tracking**: Set due dates with overdue indicators
- **Auto-completion**: Projects automatically marked as success when all tasks are done
- **Mobile Responsive**: Works seamlessly on web and mobile devices
- **Touch-Friendly**: Large buttons and touch targets optimized for mobile use

## Technology Stack

- **Backend**: PHP 7.4+
- **Database**: MySQL 5.7+
- **Frontend**: HTML5, CSS3, Bootstrap 5
- **JavaScript**: Vanilla ES6+ (no frameworks)
- **Icons**: Bootstrap Icons
- **Server**: XAMPP (Apache + MySQL)

## Installation

### Prerequisites
- XAMPP installed on your system
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Web browser (Chrome, Firefox, Safari, Edge)

### Step 1: Copy Files
1. Copy the entire `Claude` folder to your XAMPP's `htdocs` directory
   ```
   c:\xampp\htdocs\Claude\
   ```

### Step 2: Create Database
1. Open phpMyAdmin: `http://localhost/phpmyadmin`
2. Click on "Import" tab
3. Choose the file `Claude/database.sql`
4. Click "Go" to execute the SQL script
5. The database `project_manager` will be created with all tables

Alternatively, you can run the SQL manually:
```sql
-- Open phpMyAdmin SQL tab and paste the contents of database.sql
```

### Step 3: Configure Database Connection
The default configuration should work with XAMPP. If needed, edit `includes/config.php`:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'project_manager');
define('DB_USER', 'root');
define('DB_PASS', '');  // Default XAMPP password is empty
```

### Step 4: Set Permissions
Ensure the uploads directory is writable:
```bash
chmod 755 assets/uploads/
```
(On Windows, this is usually not necessary)

### Step 5: Access the Application
1. Start XAMPP (Apache and MySQL)
2. Open your browser
3. Navigate to: `http://localhost/Claude/`
4. You'll be redirected to the login page

## Default Demo Account

**Username**: `demo`
**Password**: `demo123`

Or create a new account using the registration page.

## Project Structure

```
Claude/
├── index.php                    # Entry point
├── login.php                    # Login page
├── register.php                 # Registration page
├── dashboard.php                # Main dashboard
├── project.php                  # Project detail view
├── logout.php                   # Logout handler
├── database.sql                 # Database schema
├── README.md                    # This file
├── includes/
│   ├── config.php              # Configuration
│   ├── db.php                  # Database connection
│   ├── auth.php                # Authentication functions
│   └── functions.php           # Utility functions
├── api/
│   ├── projects/               # Project CRUD APIs
│   ├── tasks/                  # Task CRUD APIs
│   ├── documents/              # Document upload/download APIs
│   ├── dashboard/              # Dashboard statistics API
│   └── activity/               # Activity log API
├── assets/
│   ├── css/
│   │   └── style.css           # Custom styles
│   ├── js/
│   │   ├── app.js              # Common utilities
│   │   ├── dashboard.js        # Dashboard functionality
│   │   └── project.js          # Project page functionality
│   └── uploads/                # Document storage
```

## Usage Guide

### Creating a Project
1. Login to your account
2. Click "New Project" button on the dashboard
3. Enter project name, description, and status
4. Click "Save Project"

### Adding Tasks
1. Click on a project to open it
2. Go to the "Tasks" tab
3. Click "Add New Task"
4. Fill in task details (title, description, notes, status, priority, due date)
5. Click "Save Task"

### Uploading Documents
1. Open a project
2. Go to the "Documents" tab
3. Click "Choose Files" and select files
4. Click "Upload Files"
5. Files will be available for download

### Tracking Progress
- Dashboard shows statistics of all projects
- Each project card displays a progress bar
- Projects automatically marked as "success" when all tasks are completed
- Activity log tracks all changes

### Mobile Usage
- Responsive design works on all screen sizes
- Touch-friendly buttons (minimum 44px)
- Bottom navigation bar on mobile devices
- Swipe gestures supported
- Can be installed as Progressive Web App (future enhancement)

## Features Breakdown

### Dashboard Features
- Total project count
- Working, stuck, and success project counts
- Project list with search and filter
- Sort by name, created date, or updated date
- Visual progress indicators
- Quick actions (view, edit, delete)

### Project Features
- Create, read, update, delete (CRUD) operations
- Three status types: Working, Stuck, Success
- Automatic completion when all tasks done
- Task completion percentage
- Document attachments
- Activity history

### Task Features
- Multiple tasks per project
- Four status types: Pending, Working, Stuck, Completed
- Three priority levels: High, Medium, Low
- Due date tracking with overdue indicators
- Task notes and descriptions
- Quick status updates

### Security Features
- Password hashing with bcrypt
- SQL injection prevention with PDO prepared statements
- XSS prevention with output escaping
- Session-based authentication
- File upload validation
- CSRF protection (tokens in forms)

## API Endpoints

All API endpoints return JSON responses.

### Projects
- `GET api/projects/list.php` - List all projects
- `GET api/projects/get.php?id=1` - Get single project
- `POST api/projects/create.php` - Create project
- `PUT api/projects/update.php` - Update project
- `DELETE api/projects/delete.php` - Delete project

### Tasks
- `GET api/tasks/list.php?project_id=1` - List tasks
- `GET api/tasks/get.php?id=1` - Get single task
- `POST api/tasks/create.php` - Create task
- `PUT api/tasks/update.php` - Update task
- `DELETE api/tasks/delete.php` - Delete task

### Documents
- `POST api/documents/upload.php` - Upload files
- `GET api/documents/download.php?id=1` - Download file
- `GET api/documents/list.php?project_id=1` - List documents
- `DELETE api/documents/delete.php` - Delete document

### Dashboard
- `GET api/dashboard/stats.php` - Get statistics

### Activity
- `GET api/activity/list.php` - Get activity log
- `GET api/activity/list.php?project_id=1` - Get project activity

## Configuration Options

Edit `includes/config.php` to customize:

```php
// Application settings
define('APP_NAME', 'Project Manager');
define('APP_URL', 'http://localhost/Claude');
define('UPLOAD_DIR', __DIR__ . '/../assets/uploads/');
define('MAX_FILE_SIZE', 10485760); // 10MB
define('ALLOWED_FILE_TYPES', ['pdf', 'doc', 'docx', ...]);

// Timezone
date_default_timezone_set('UTC');
```

## Troubleshooting

### Database Connection Error
- Verify MySQL is running in XAMPP
- Check database credentials in `includes/config.php`
- Ensure database `project_manager` exists

### File Upload Issues
- Check `assets/uploads/` directory exists and is writable
- Verify `MAX_FILE_SIZE` in `config.php`
- Check PHP upload limits in `php.ini`:
  ```ini
  upload_max_filesize = 10M
  post_max_size = 10M
  ```

### Permission Denied
- Ensure Apache has read/write permissions
- On Linux/Mac: `chmod 755 Claude/`
- On Windows: Usually no action needed

### Page Not Loading
- Clear browser cache
- Check Apache error logs in XAMPP
- Verify `.htaccess` if using mod_rewrite

## Browser Compatibility

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Mobile browsers (iOS Safari, Chrome Mobile)

## Future Enhancements

- Team collaboration (multiple users per project)
- Email notifications
- Kanban board view
- Gantt chart timeline
- Export to PDF/Excel
- Dark mode
- Progressive Web App (PWA)
- Real-time updates with WebSockets
- Project templates
- Multi-language support

## License

This project is open source and available for personal and commercial use.

## Support

For issues or questions:
1. Check the troubleshooting section
2. Review XAMPP logs
3. Check browser console for JavaScript errors

## Credits

- Built with Bootstrap 5
- Icons by Bootstrap Icons
- Charts by Chart.js (optional)

---

**Version**: 1.0.0
**Last Updated**: 2026-01-29
**Author**: Claude (Anthropic)
