<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';
require_once 'includes/functions.php';

requireAuth();
$user = getCurrentUser();

$projectId = intval($_GET['project_id'] ?? 0);
if ($projectId <= 0) {
    header('Location: dashboard.php');
    exit;
}

// Verify ownership
if (!userOwnsProject($projectId, $user['id'])) {
    header('Location: dashboard.php');
    exit;
}

// Get project details
$db = getDB();
$stmt = $db->prepare("SELECT * FROM projects WHERE id = ? AND deleted_at IS NULL");
$stmt->execute([$projectId]);
$project = $stmt->fetch();

if (!$project) {
    header('Location: dashboard.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Accounts - <?php echo e($project['name']); ?> - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.2/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/accounts.css?v=<?php echo time(); ?>">
</head>
<body>
    <!-- Top Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm sticky-top">
        <div class="container-fluid">
            <a class="navbar-brand fw-bold" href="project.php?id=<?php echo $projectId; ?>">
                <i class="bi bi-arrow-left-circle me-2"></i>Back to Project
            </a>
            <div class="d-flex align-items-center">
                <button class="btn btn-outline-light btn-sm me-2" id="addTransactionBtn">
                    <i class="bi bi-plus-circle me-1"></i><span class="d-none d-md-inline">Add Transaction</span>
                </button>
                <button class="btn btn-outline-light btn-sm me-2" id="manageContactsBtn">
                    <i class="bi bi-people me-1"></i><span class="d-none d-md-inline">Contacts</span>
                </button>
                <button class="btn btn-outline-light btn-sm" id="manageMethodsBtn">
                    <i class="bi bi-credit-card me-1"></i><span class="d-none d-md-inline">Methods</span>
                </button>
            </div>
        </div>
    </nav>

    <div class="container-fluid py-4">
        <!-- Project Title -->
        <div class="mb-4">
            <h2 class="mb-1"><i class="bi bi-currency-dollar text-success me-2"></i><?php echo e($project['name']); ?></h2>
            <p class="text-muted mb-0">Financial Management & Accounting</p>
        </div>

        <!-- Stats Cards -->
        <div class="row g-3 mb-4" id="statsCards">
            <div class="col-6 col-md-3">
                <div class="card stat-card bg-success text-white h-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <p class="mb-1 small">Total Income</p>
                                <h2 class="mb-0" id="totalIncome">$0.00</h2>
                            </div>
                            <i class="bi bi-arrow-down-circle-fill fs-2 opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="card stat-card bg-danger text-white h-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <p class="mb-1 small">Total Expense</p>
                                <h2 class="mb-0" id="totalExpense">$0.00</h2>
                            </div>
                            <i class="bi bi-arrow-up-circle-fill fs-2 opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="card stat-card bg-primary text-white h-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <p class="mb-1 small">Net Profit</p>
                                <h2 class="mb-0" id="netProfit">$0.00</h2>
                            </div>
                            <i class="bi bi-graph-up-arrow fs-2 opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="card stat-card bg-info text-white h-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <p class="mb-1 small">Pending Invoices</p>
                                <h2 class="mb-0" id="pendingInvoices">0</h2>
                            </div>
                            <i class="bi bi-file-earmark-text fs-2 opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-2">
                        <label class="form-label small">Start Date</label>
                        <input type="date" class="form-control" id="startDate">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">End Date</label>
                        <input type="date" class="form-control" id="endDate">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">Type</label>
                        <select class="form-select" id="typeFilter">
                            <option value="">All Types</option>
                            <option value="income">Income</option>
                            <option value="expense">Expense</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">Contact</label>
                        <select class="form-select" id="contactFilter">
                            <option value="">All Contacts</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">Method</label>
                        <select class="form-select" id="methodFilter">
                            <option value="">All Methods</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">&nbsp;</label>
                        <button class="btn btn-primary w-100" id="applyFilters">
                            <i class="bi bi-funnel-fill me-1"></i>Filter
                        </button>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-md-6">
                        <input type="text" class="form-control" id="searchFilter" placeholder="Search transactions...">
                    </div>
                    <div class="col-md-6 text-end">
                        <button class="btn btn-outline-secondary" id="clearFilters">
                            <i class="bi bi-x-circle me-1"></i>Clear Filters
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Transactions List -->
        <div class="card shadow-sm">
            <div class="card-header bg-white">
                <h5 class="mb-0"><i class="bi bi-list-ul me-2"></i>Transactions</h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0" id="transactionsTable">
                        <thead class="table-light">
                            <tr>
                                <th>Date</th>
                                <th>Contact</th>
                                <th>Description</th>
                                <th class="text-end">Income</th>
                                <th>Method</th>
                                <th class="text-end">Expense</th>
                                <th>Method</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody id="transactionsList">
                            <tr>
                                <td colspan="8" class="text-center py-5">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer bg-white">
                <div class="row">
                    <div class="col-md-4 text-start">
                        <strong>Total Income: <span class="text-success" id="summaryIncome">$0.00</span></strong>
                    </div>
                    <div class="col-md-4 text-center">
                        <strong>Total Expense: <span class="text-danger" id="summaryExpense">$0.00</span></strong>
                    </div>
                    <div class="col-md-4 text-end">
                        <strong>Net: <span id="summaryNet">$0.00</span></strong>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add/Edit Transaction Modal -->
    <div class="modal fade" id="transactionModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="transactionModalTitle">Add Transaction</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="transactionForm">
                        <input type="hidden" id="transactionId">
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Date *</label>
                            <input type="date" class="form-control" id="transactionDate" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Type *</label>
                            <select class="form-select" id="transactionType" required>
                                <option value="income">Income</option>
                                <option value="expense">Expense</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Contact</label>
                            <select class="form-select" id="transactionContact">
                                <option value="">Select Contact...</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Description *</label>
                            <textarea class="form-control" id="transactionDescription" rows="3" required></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Amount *</label>
                            <div class="input-group">
                                <span class="input-group-text">$</span>
                                <input type="number" class="form-control" id="transactionAmount" step="0.01" min="0" required>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Payment Method</label>
                            <select class="form-select" id="transactionMethod">
                                <option value="">Select Method...</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Notes</label>
                            <textarea class="form-control" id="transactionNotes" rows="2"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="saveTransactionBtn">
                        <i class="bi bi-check-circle-fill me-1"></i>Save Transaction
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Manage Contacts Modal -->
    <div class="modal fade" id="contactsModal" tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="bi bi-people me-2"></i>Manage Contacts</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <button class="btn btn-primary mb-3" id="addContactBtn">
                        <i class="bi bi-plus-circle me-1"></i>Add Contact
                    </button>
                    <div id="contactsList">
                        <div class="text-center py-3">
                            <div class="spinner-border text-primary" role="status"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add/Edit Contact Modal -->
    <div class="modal fade" id="contactFormModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="contactFormModalTitle">Add Contact</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="contactForm">
                        <input type="hidden" id="contactId">
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Name *</label>
                            <input type="text" class="form-control" id="contactName" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Type *</label>
                            <select class="form-select" id="contactType" required>
                                <option value="customer">Customer</option>
                                <option value="vendor">Vendor</option>
                                <option value="both">Both</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Email</label>
                            <input type="email" class="form-control" id="contactEmail">
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Phone</label>
                            <input type="tel" class="form-control" id="contactPhone">
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Address</label>
                            <textarea class="form-control" id="contactAddress" rows="2"></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Notes</label>
                            <textarea class="form-control" id="contactNotes" rows="2"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="saveContactBtn">
                        <i class="bi bi-check-circle-fill me-1"></i>Save Contact
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Manage Payment Methods Modal -->
    <div class="modal fade" id="methodsModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="bi bi-credit-card me-2"></i>Payment Methods</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <button class="btn btn-primary mb-3" id="addMethodBtn">
                        <i class="bi bi-plus-circle me-1"></i>Add Method
                    </button>
                    <div id="methodsList">
                        <div class="text-center py-3">
                            <div class="spinner-border text-primary" role="status"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add/Edit Payment Method Modal -->
    <div class="modal fade" id="methodFormModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="methodFormModalTitle">Add Payment Method</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="methodForm">
                        <input type="hidden" id="methodId">
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Name *</label>
                            <input type="text" class="form-control" id="methodName" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Type *</label>
                            <select class="form-select" id="methodType" required>
                                <option value="both">Both Income & Expense</option>
                                <option value="income">Income Only</option>
                                <option value="expense">Expense Only</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="methodIsDefault">
                                <label class="form-check-label" for="methodIsDefault">
                                    Set as default
                                </label>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="saveMethodBtn">
                        <i class="bi bi-check-circle-fill me-1"></i>Save Method
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title">Confirm Delete</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p id="deleteMessage">Are you sure you want to delete this item?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">
                        <i class="bi bi-trash-fill me-1"></i>Delete
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Invoice Modal -->
    <div class="modal fade" id="invoiceModal" tabindex="-1">
        <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title"><i class="bi bi-file-earmark-text me-2"></i>Generate Invoice</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="invoiceForm">
                        <input type="hidden" id="invoiceTransactionId">
                        <input type="hidden" id="invoiceId">

                        <!-- Company Information -->
                        <div class="card mb-3">
                            <div class="card-header bg-light">
                                <h6 class="mb-0"><i class="bi bi-building me-2"></i>Company Information</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-semibold">Company Name *</label>
                                        <input type="text" class="form-control" id="invoiceCompanyName" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-semibold">Email</label>
                                        <input type="email" class="form-control" id="invoiceCompanyEmail">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-semibold">Phone</label>
                                        <input type="tel" class="form-control" id="invoiceCompanyPhone">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-semibold">Address</label>
                                        <textarea class="form-control" id="invoiceCompanyAddress" rows="2"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Customer Information -->
                        <div class="card mb-3">
                            <div class="card-header bg-light">
                                <h6 class="mb-0"><i class="bi bi-person me-2"></i>Customer Information</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-semibold">Select Customer</label>
                                        <select class="form-select" id="invoiceCustomerSelect">
                                            <option value="">Select or enter manually...</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-semibold">Customer Name *</label>
                                        <input type="text" class="form-control" id="invoiceCustomerName" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-semibold">Email</label>
                                        <input type="email" class="form-control" id="invoiceCustomerEmail">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label fw-semibold">Phone</label>
                                        <input type="tel" class="form-control" id="invoiceCustomerPhone">
                                    </div>
                                    <div class="col-md-12 mb-3">
                                        <label class="form-label fw-semibold">Address</label>
                                        <textarea class="form-control" id="invoiceCustomerAddress" rows="2"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Invoice Details -->
                        <div class="card mb-3">
                            <div class="card-header bg-light">
                                <h6 class="mb-0"><i class="bi bi-calendar me-2"></i>Invoice Details</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label fw-semibold">Invoice Date *</label>
                                        <input type="date" class="form-control" id="invoiceDate" required>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label fw-semibold">Due Date</label>
                                        <input type="date" class="form-control" id="invoiceDueDate">
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label fw-semibold">Payment Method</label>
                                        <select class="form-select" id="invoicePaymentMethod">
                                            <option value="">Select method...</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Line Items -->
                        <div class="card mb-3">
                            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                <h6 class="mb-0"><i class="bi bi-list-ul me-2"></i>Services / Items</h6>
                                <button type="button" class="btn btn-sm btn-primary" id="addInvoiceItemBtn">
                                    <i class="bi bi-plus-circle me-1"></i>Add Item
                                </button>
                            </div>
                            <div class="card-body">
                                <div id="invoiceItems">
                                    <!-- Items will be added here dynamically -->
                                </div>
                            </div>
                        </div>

                        <!-- Tax and Totals -->
                        <div class="card mb-3">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="form-label fw-semibold">Tax Rate (%)</label>
                                        <input type="number" class="form-control" id="invoiceTaxRate" value="0" min="0" max="100" step="0.01">
                                    </div>
                                    <div class="col-md-6">
                                        <div class="invoice-totals mt-3">
                                            <div class="d-flex justify-content-between mb-2">
                                                <strong>Subtotal:</strong>
                                                <span id="invoiceSubtotal">$0.00</span>
                                            </div>
                                            <div class="d-flex justify-content-between mb-2">
                                                <strong>Tax:</strong>
                                                <span id="invoiceTaxAmount">$0.00</span>
                                            </div>
                                            <div class="d-flex justify-content-between border-top pt-2">
                                                <strong class="fs-5">Total:</strong>
                                                <strong class="fs-5 text-primary" id="invoiceTotal">$0.00</strong>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Notes -->
                        <div class="card mb-3">
                            <div class="card-body">
                                <label class="form-label fw-semibold">Notes</label>
                                <textarea class="form-control" id="invoiceNotes" rows="3" placeholder="Thank you for your business!"></textarea>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="saveInvoiceBtn">
                        <i class="bi bi-check-circle-fill me-1"></i>Generate Invoice
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        const PROJECT_ID = <?php echo $projectId; ?>;
        const PROJECT_NAME = <?php echo json_encode($project['name']); ?>;
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/app.js?v=<?php echo time(); ?>"></script>
    <script src="assets/js/accounts.js?v=<?php echo time(); ?>"></script>
</body>
</html>
