-- Add document notes and URLs feature
-- Run this in phpMyAdmin

USE project_manager;

-- Add document_notes column to projects table
ALTER TABLE projects ADD COLUMN IF NOT EXISTS document_notes TEXT NULL AFTER description;

-- Create project_urls table for storing URLs
CREATE TABLE IF NOT EXISTS project_urls (
    id INT PRIMARY KEY AUTO_INCREMENT,
    project_id INT NOT NULL,
    title VARCHAR(200) NOT NULL,
    url VARCHAR(500) NOT NULL,
    description TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (project_id) REFERENCES projects(id) ON DELETE CASCADE,
    INDEX idx_project_id (project_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

SELECT 'Document features added successfully!' AS message;
