<?php
require_once '../../../includes/config.php';
require_once '../../../includes/db.php';
require_once '../../../includes/auth.php';
require_once '../../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

if ($_SERVER['REQUEST_METHOD'] !== 'DELETE' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'message' => 'Invalid request method'], 405);
}

$userId = getCurrentUserId();
$data = json_decode(file_get_contents('php://input'), true);

$contactId = intval($data['id'] ?? $_GET['id'] ?? 0);

if ($contactId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid contact ID'], 400);
}

$db = getDB();

try {
    // Verify contact exists and user owns the project
    $stmt = $db->prepare("
        SELECT c.project_id
        FROM contacts c
        JOIN projects p ON c.project_id = p.id
        WHERE c.id = ? AND p.user_id = ?
    ");
    $stmt->execute([$contactId, $userId]);
    $contact = $stmt->fetch();

    if (!$contact) {
        jsonResponse(['success' => false, 'message' => 'Contact not found or unauthorized'], 404);
    }

    // Check if contact has transactions
    $stmt = $db->prepare("SELECT COUNT(*) as count FROM transactions WHERE contact_id = ?");
    $stmt->execute([$contactId]);
    $result = $stmt->fetch();

    if ($result['count'] > 0) {
        jsonResponse(['success' => false, 'message' => 'Cannot delete contact with associated transactions'], 400);
    }

    // Delete contact
    $stmt = $db->prepare("DELETE FROM contacts WHERE id = ?");
    $stmt->execute([$contactId]);

    jsonResponse([
        'success' => true,
        'message' => 'Contact deleted successfully'
    ]);

} catch (PDOException $e) {
    error_log("Delete Contact Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to delete contact'], 500);
}
