<?php
require_once '../../../includes/config.php';
require_once '../../../includes/db.php';
require_once '../../../includes/auth.php';
require_once '../../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

$userId = getCurrentUserId();
$contactId = intval($_GET['id'] ?? 0);

if ($contactId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid contact ID'], 400);
}

$db = getDB();

try {
    // Get contact with verification
    $stmt = $db->prepare("
        SELECT c.*
        FROM contacts c
        JOIN projects p ON c.project_id = p.id
        WHERE c.id = ? AND p.user_id = ?
    ");
    $stmt->execute([$contactId, $userId]);
    $contact = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$contact) {
        jsonResponse(['success' => false, 'message' => 'Contact not found or unauthorized'], 404);
    }

    jsonResponse([
        'success' => true,
        'contact' => $contact
    ]);

} catch (PDOException $e) {
    error_log("Get Contact Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to fetch contact'], 500);
}
