<?php
require_once '../../../includes/config.php';
require_once '../../../includes/db.php';
require_once '../../../includes/auth.php';
require_once '../../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

$userId = getCurrentUserId();
$projectId = intval($_GET['project_id'] ?? 0);

if ($projectId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid project ID'], 400);
}

// Verify project ownership
if (!userOwnsProject($projectId, $userId)) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized access'], 403);
}

$db = getDB();

try {
    $stmt = $db->prepare("
        SELECT
            id,
            name,
            type,
            email,
            phone,
            address,
            notes,
            created_at,
            updated_at
        FROM contacts
        WHERE project_id = ?
        ORDER BY name ASC
    ");

    $stmt->execute([$projectId]);
    $contacts = $stmt->fetchAll(PDO::FETCH_ASSOC);

    jsonResponse([
        'success' => true,
        'contacts' => $contacts,
        'total_count' => count($contacts)
    ]);

} catch (PDOException $e) {
    error_log("Contacts List Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to fetch contacts'], 500);
}
