<?php
require_once '../../../includes/config.php';
require_once '../../../includes/db.php';
require_once '../../../includes/auth.php';
require_once '../../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

$userId = getCurrentUserId();
$invoiceId = intval($_GET['id'] ?? 0);

if ($invoiceId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid invoice ID'], 400);
}

$db = getDB();

try {
    // Get invoice with verification
    $stmt = $db->prepare("
        SELECT i.*
        FROM invoices i
        JOIN projects p ON i.project_id = p.id
        WHERE i.id = ? AND p.user_id = ?
    ");
    $stmt->execute([$invoiceId, $userId]);
    $invoice = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$invoice) {
        jsonResponse(['success' => false, 'message' => 'Invoice not found or unauthorized'], 404);
    }

    // Decode JSON items
    $invoice['items'] = json_decode($invoice['items'], true);

    // Convert numeric values
    $invoice['subtotal'] = floatval($invoice['subtotal']);
    $invoice['tax_rate'] = floatval($invoice['tax_rate']);
    $invoice['tax_amount'] = floatval($invoice['tax_amount']);
    $invoice['total_amount'] = floatval($invoice['total_amount']);

    jsonResponse([
        'success' => true,
        'invoice' => $invoice
    ]);

} catch (PDOException $e) {
    error_log("Get Invoice Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to fetch invoice'], 500);
}
