<?php
require_once '../../../includes/config.php';
require_once '../../../includes/db.php';
require_once '../../../includes/auth.php';
require_once '../../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

if ($_SERVER['REQUEST_METHOD'] !== 'DELETE' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'message' => 'Invalid request method'], 405);
}

$userId = getCurrentUserId();
$data = json_decode(file_get_contents('php://input'), true);

$methodId = intval($data['id'] ?? $_GET['id'] ?? 0);

if ($methodId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid payment method ID'], 400);
}

$db = getDB();

try {
    // Verify method exists and user owns the project
    $stmt = $db->prepare("
        SELECT pm.project_id
        FROM payment_methods pm
        JOIN projects p ON pm.project_id = p.id
        WHERE pm.id = ? AND p.user_id = ?
    ");
    $stmt->execute([$methodId, $userId]);
    $method = $stmt->fetch();

    if (!$method) {
        jsonResponse(['success' => false, 'message' => 'Payment method not found or unauthorized'], 404);
    }

    // Check if method has transactions
    $stmt = $db->prepare("SELECT COUNT(*) as count FROM transactions WHERE payment_method_id = ?");
    $stmt->execute([$methodId]);
    $result = $stmt->fetch();

    if ($result['count'] > 0) {
        jsonResponse(['success' => false, 'message' => 'Cannot delete payment method with associated transactions'], 400);
    }

    // Delete payment method
    $stmt = $db->prepare("DELETE FROM payment_methods WHERE id = ?");
    $stmt->execute([$methodId]);

    jsonResponse([
        'success' => true,
        'message' => 'Payment method deleted successfully'
    ]);

} catch (PDOException $e) {
    error_log("Delete Payment Method Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to delete payment method'], 500);
}
