<?php
require_once '../../../includes/config.php';
require_once '../../../includes/db.php';
require_once '../../../includes/auth.php';
require_once '../../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

$userId = getCurrentUserId();
$projectId = intval($_GET['project_id'] ?? 0);

if ($projectId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid project ID'], 400);
}

// Verify project ownership
if (!userOwnsProject($projectId, $userId)) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized access'], 403);
}

$db = getDB();

try {
    $stmt = $db->prepare("
        SELECT
            id,
            name,
            type,
            is_default,
            created_at
        FROM payment_methods
        WHERE project_id = ?
        ORDER BY is_default DESC, name ASC
    ");

    $stmt->execute([$projectId]);
    $methods = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Convert is_default to boolean
    foreach ($methods as &$method) {
        $method['is_default'] = (bool)$method['is_default'];
    }

    jsonResponse([
        'success' => true,
        'payment_methods' => $methods,
        'total_count' => count($methods)
    ]);

} catch (PDOException $e) {
    error_log("Payment Methods List Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to fetch payment methods'], 500);
}
