<?php
require_once '../../../includes/config.php';
require_once '../../../includes/db.php';
require_once '../../../includes/auth.php';
require_once '../../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

if ($_SERVER['REQUEST_METHOD'] !== 'DELETE' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'message' => 'Invalid request method'], 405);
}

$userId = getCurrentUserId();
$data = json_decode(file_get_contents('php://input'), true);

$transactionId = intval($data['id'] ?? $_GET['id'] ?? 0);

if ($transactionId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid transaction ID'], 400);
}

$db = getDB();

try {
    // Verify transaction exists and user owns the project
    $stmt = $db->prepare("
        SELECT t.project_id, t.invoice_id
        FROM transactions t
        JOIN projects p ON t.project_id = p.id
        WHERE t.id = ? AND p.user_id = ?
    ");
    $stmt->execute([$transactionId, $userId]);
    $transaction = $stmt->fetch();

    if (!$transaction) {
        jsonResponse(['success' => false, 'message' => 'Transaction not found or unauthorized'], 404);
    }

    // Check if transaction has an invoice
    if ($transaction['invoice_id']) {
        jsonResponse(['success' => false, 'message' => 'Cannot delete transaction with an associated invoice. Delete the invoice first.'], 400);
    }

    // Delete transaction
    $stmt = $db->prepare("DELETE FROM transactions WHERE id = ?");
    $stmt->execute([$transactionId]);

    jsonResponse([
        'success' => true,
        'message' => 'Transaction deleted successfully'
    ]);

} catch (PDOException $e) {
    error_log("Delete Transaction Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to delete transaction'], 500);
}
