<?php
require_once '../../../includes/config.php';
require_once '../../../includes/db.php';
require_once '../../../includes/auth.php';
require_once '../../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

$userId = getCurrentUserId();
$transactionId = intval($_GET['id'] ?? 0);

if ($transactionId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid transaction ID'], 400);
}

$db = getDB();

try {
    // Get transaction with verification
    $stmt = $db->prepare("
        SELECT
            t.id,
            t.project_id,
            t.transaction_date,
            t.description,
            t.amount,
            t.type,
            t.notes,
            t.invoice_id,
            c.id as contact_id,
            c.name as contact_name,
            c.email as contact_email,
            c.phone as contact_phone,
            c.address as contact_address,
            pm.id as method_id,
            pm.name as method_name,
            t.created_at,
            t.updated_at
        FROM transactions t
        JOIN projects p ON t.project_id = p.id
        LEFT JOIN contacts c ON t.contact_id = c.id
        LEFT JOIN payment_methods pm ON t.payment_method_id = pm.id
        WHERE t.id = ? AND p.user_id = ?
    ");
    $stmt->execute([$transactionId, $userId]);
    $transaction = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$transaction) {
        jsonResponse(['success' => false, 'message' => 'Transaction not found or unauthorized'], 404);
    }

    $transaction['amount'] = floatval($transaction['amount']);

    jsonResponse([
        'success' => true,
        'transaction' => $transaction
    ]);

} catch (PDOException $e) {
    error_log("Get Transaction Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to fetch transaction'], 500);
}
