<?php
require_once '../../includes/config.php';
require_once '../../includes/db.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

$userId = getCurrentUserId();
$projectId = isset($_GET['project_id']) ? intval($_GET['project_id']) : null;
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 50;
$limit = min($limit, 200); // Max 200 results

$db = getDB();

try {
    $sql = "
        SELECT
            a.*,
            p.name as project_name,
            t.title as task_title
        FROM activity_logs a
        LEFT JOIN projects p ON a.project_id = p.id
        LEFT JOIN tasks t ON a.task_id = t.id
        WHERE a.user_id = ?
    ";

    $params = [$userId];

    // Filter by project if specified
    if ($projectId) {
        // Check project ownership
        if (!userOwnsProject($projectId, $userId)) {
            jsonResponse(['success' => false, 'message' => 'Unauthorized'], 403);
        }

        $sql .= " AND a.project_id = ?";
        $params[] = $projectId;
    }

    $sql .= " ORDER BY a.created_at DESC LIMIT ?";
    $params[] = $limit;

    $stmt = $db->prepare($sql);
    $stmt->execute($params);
    $activities = $stmt->fetchAll();

    jsonResponse([
        'success' => true,
        'activities' => $activities
    ]);
} catch (PDOException $e) {
    error_log("Activity List Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to fetch activity log'], 500);
}
