<?php
require_once '../../includes/config.php';
require_once '../../includes/db.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

$userId = getCurrentUserId();
$db = getDB();

try {
    // Get all overdue tasks with project information
    $stmt = $db->prepare("
        SELECT
            t.id as task_id,
            t.title as task_title,
            t.description as task_description,
            t.status as task_status,
            t.priority as task_priority,
            t.due_date as task_due_date,
            DATEDIFF(CURDATE(), t.due_date) as days_overdue,
            p.id as project_id,
            p.name as project_name
        FROM tasks t
        JOIN projects p ON t.project_id = p.id
        WHERE p.user_id = ?
        AND t.status != 'completed'
        AND t.due_date IS NOT NULL
        AND t.due_date <= CURDATE()
        ORDER BY days_overdue DESC, p.name ASC, t.priority DESC
    ");

    $stmt->execute([$userId]);
    $overdueTasks = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Convert days_overdue to integer
    foreach ($overdueTasks as &$task) {
        $task['days_overdue'] = intval($task['days_overdue']);
    }

    jsonResponse([
        'success' => true,
        'overdue_tasks' => $overdueTasks,
        'total_count' => count($overdueTasks)
    ]);

} catch (PDOException $e) {
    error_log("Overdue Tasks Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to fetch overdue tasks'], 500);
}
