<?php
require_once '../../includes/config.php';
require_once '../../includes/db.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

if ($_SERVER['REQUEST_METHOD'] !== 'DELETE' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'message' => 'Method not allowed'], 405);
}

$data = json_decode(file_get_contents('php://input'), true);
$documentId = intval($data['id'] ?? $_GET['id'] ?? 0);

if ($documentId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid document ID']);
}

$userId = getCurrentUserId();
$result = deleteFile($documentId, $userId);

if ($result['success']) {
    // Log activity
    $db = getDB();
    $stmt = $db->prepare("SELECT project_id FROM documents WHERE id = ?");
    $stmt->execute([$documentId]);
    $doc = $stmt->fetch();

    if ($doc) {
        logActivity($userId, 'delete_document', "Deleted document", $doc['project_id']);
    }
}

jsonResponse($result);
