<?php
require_once '../../includes/config.php';
require_once '../../includes/db.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

if (!isLoggedIn()) {
    http_response_code(401);
    die('Unauthorized');
}

$documentId = intval($_GET['id'] ?? 0);

if ($documentId <= 0) {
    http_response_code(400);
    die('Invalid document ID');
}

$userId = getCurrentUserId();
$db = getDB();

try {
    // Get document and check ownership
    $stmt = $db->prepare("
        SELECT d.*, p.user_id
        FROM documents d
        JOIN projects p ON d.project_id = p.id
        WHERE d.id = ?
    ");
    $stmt->execute([$documentId]);
    $document = $stmt->fetch();

    if (!$document) {
        http_response_code(404);
        die('Document not found');
    }

    if ($document['user_id'] != $userId) {
        http_response_code(403);
        die('Unauthorized');
    }

    // Check if file exists
    if (!file_exists($document['file_path'])) {
        http_response_code(404);
        die('File not found');
    }

    // Get MIME type
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $mimeType = finfo_file($finfo, $document['file_path']);
    finfo_close($finfo);

    // Set headers for download
    header('Content-Type: ' . $mimeType);
    header('Content-Disposition: attachment; filename="' . $document['original_filename'] . '"');
    header('Content-Length: ' . $document['file_size']);
    header('Cache-Control: no-cache, must-revalidate');
    header('Pragma: public');

    // Output file
    readfile($document['file_path']);
    exit;

} catch (PDOException $e) {
    error_log("Download Document Error: " . $e->getMessage());
    http_response_code(500);
    die('Failed to download document');
}
