<?php
require_once '../../includes/config.php';
require_once '../../includes/db.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

$projectId = intval($_GET['project_id'] ?? 0);

if ($projectId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid project ID']);
}

$userId = getCurrentUserId();

// Check project ownership
if (!userOwnsProject($projectId, $userId)) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 403);
}

$db = getDB();

try {
    $stmt = $db->prepare("
        SELECT id, filename, original_filename, file_size, uploaded_at
        FROM documents
        WHERE project_id = ?
        ORDER BY uploaded_at DESC
    ");
    $stmt->execute([$projectId]);
    $documents = $stmt->fetchAll();

    // Format file sizes
    foreach ($documents as &$doc) {
        $doc['file_size_formatted'] = formatFileSize($doc['file_size']);
    }

    jsonResponse([
        'success' => true,
        'documents' => $documents
    ]);
} catch (PDOException $e) {
    error_log("List Documents Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to fetch documents'], 500);
}
