<?php
require_once '../../includes/config.php';
require_once '../../includes/db.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'message' => 'Method not allowed'], 405);
}

$projectId = intval($_POST['project_id'] ?? 0);

if ($projectId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid project ID']);
}

$userId = getCurrentUserId();

// Check project ownership
if (!userOwnsProject($projectId, $userId)) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 403);
}

// Check if files were uploaded
if (!isset($_FILES['files']) || empty($_FILES['files']['name'][0])) {
    jsonResponse(['success' => false, 'message' => 'No files uploaded']);
}

$uploadedFiles = [];
$errors = [];

// Handle multiple file uploads
$fileCount = count($_FILES['files']['name']);

for ($i = 0; $i < $fileCount; $i++) {
    $file = [
        'name' => $_FILES['files']['name'][$i],
        'type' => $_FILES['files']['type'][$i],
        'tmp_name' => $_FILES['files']['tmp_name'][$i],
        'error' => $_FILES['files']['error'][$i],
        'size' => $_FILES['files']['size'][$i]
    ];

    $result = handleFileUpload($file, $projectId);

    if ($result['success']) {
        $uploadedFiles[] = [
            'id' => $result['document_id'],
            'filename' => $result['filename'],
            'original_filename' => $file['name']
        ];

        // Log activity
        logActivity($userId, 'upload_document', "Uploaded document: {$file['name']}", $projectId);
    } else {
        $errors[] = $result['message'] . " ({$file['name']})";
    }
}

if (empty($uploadedFiles) && !empty($errors)) {
    jsonResponse([
        'success' => false,
        'message' => 'All uploads failed',
        'errors' => $errors
    ]);
}

jsonResponse([
    'success' => true,
    'message' => count($uploadedFiles) . ' file(s) uploaded successfully',
    'files' => $uploadedFiles,
    'errors' => $errors
]);
