<?php
require_once '../../includes/config.php';
require_once '../../includes/db.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'message' => 'Method not allowed'], 405);
}

$data = json_decode(file_get_contents('php://input'), true);

$name = trim($data['name'] ?? '');
$description = trim($data['description'] ?? '');
$status = $data['status'] ?? 'working';

// Validation
if (empty($name)) {
    jsonResponse(['success' => false, 'message' => 'Project name is required']);
}

if (!in_array($status, ['working', 'stuck', 'success'])) {
    $status = 'working';
}

$userId = getCurrentUserId();
$db = getDB();

try {
    $stmt = $db->prepare("
        INSERT INTO projects (user_id, name, description, status)
        VALUES (?, ?, ?, ?)
    ");
    $stmt->execute([$userId, $name, $description, $status]);

    $projectId = $db->lastInsertId();

    // Log activity
    logActivity($userId, 'create_project', "Created project: $name", $projectId);

    jsonResponse([
        'success' => true,
        'message' => 'Project created successfully',
        'project_id' => $projectId
    ]);
} catch (PDOException $e) {
    error_log("Create Project Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to create project'], 500);
}
