<?php
require_once '../../includes/config.php';
require_once '../../includes/db.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'message' => 'Method not allowed'], 405);
}

$data = json_decode(file_get_contents('php://input'), true);

$projectId = intval($data['project_id'] ?? 0);
$notes = trim($data['notes'] ?? '');

if ($projectId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid project ID']);
}

$userId = getCurrentUserId();

// Check ownership
if (!userOwnsProject($projectId, $userId)) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 403);
}

$db = getDB();

try {
    $stmt = $db->prepare("UPDATE projects SET document_notes = ? WHERE id = ?");
    $stmt->execute([$notes, $projectId]);

    // Log activity
    logActivity($userId, 'update_document_notes', "Updated document notes", $projectId);

    jsonResponse([
        'success' => true,
        'message' => 'Notes updated successfully'
    ]);
} catch (PDOException $e) {
    error_log("Update Notes Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to update notes'], 500);
}
