<?php
require_once '../../includes/config.php';
require_once '../../includes/db.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

if ($_SERVER['REQUEST_METHOD'] !== 'DELETE' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'message' => 'Method not allowed'], 405);
}

$data = json_decode(file_get_contents('php://input'), true);
$taskId = intval($data['id'] ?? $_GET['id'] ?? 0);

if ($taskId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid task ID']);
}

$userId = getCurrentUserId();
$db = getDB();

try {
    // Get task and check ownership
    $stmt = $db->prepare("
        SELECT t.*, p.user_id
        FROM tasks t
        JOIN projects p ON t.project_id = p.id
        WHERE t.id = ?
    ");
    $stmt->execute([$taskId]);
    $task = $stmt->fetch();

    if (!$task) {
        jsonResponse(['success' => false, 'message' => 'Task not found'], 404);
    }

    if ($task['user_id'] != $userId) {
        jsonResponse(['success' => false, 'message' => 'Unauthorized'], 403);
    }

    // Delete task
    $stmt = $db->prepare("DELETE FROM tasks WHERE id = ?");
    $stmt->execute([$taskId]);

    // Log activity
    logActivity($userId, 'delete_task', "Deleted task: {$task['title']}", $task['project_id']);

    jsonResponse([
        'success' => true,
        'message' => 'Task deleted successfully'
    ]);
} catch (PDOException $e) {
    error_log("Delete Task Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to delete task'], 500);
}
