<?php
require_once '../../includes/config.php';
require_once '../../includes/db.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

$taskId = intval($_GET['id'] ?? 0);

if ($taskId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid task ID']);
}

$userId = getCurrentUserId();
$db = getDB();

try {
    $stmt = $db->prepare("
        SELECT t.*, p.user_id
        FROM tasks t
        JOIN projects p ON t.project_id = p.id
        WHERE t.id = ?
    ");
    $stmt->execute([$taskId]);
    $task = $stmt->fetch();

    if (!$task) {
        jsonResponse(['success' => false, 'message' => 'Task not found'], 404);
    }

    if ($task['user_id'] != $userId) {
        jsonResponse(['success' => false, 'message' => 'Unauthorized'], 403);
    }

    // Remove user_id from response
    unset($task['user_id']);

    jsonResponse([
        'success' => true,
        'task' => $task
    ]);
} catch (PDOException $e) {
    error_log("Get Task Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to fetch task'], 500);
}
