<?php
require_once '../../includes/config.php';
require_once '../../includes/db.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

$projectId = intval($_GET['project_id'] ?? 0);

if ($projectId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid project ID']);
}

$userId = getCurrentUserId();

// Check project ownership
if (!userOwnsProject($projectId, $userId)) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 403);
}

$db = getDB();

// Get filter parameters
$status = $_GET['status'] ?? null;
$priority = $_GET['priority'] ?? null;
$sortBy = $_GET['sort'] ?? 'created_at';
$sortOrder = $_GET['order'] ?? 'ASC';

// Validate sort parameters
$allowedSort = ['title', 'status', 'priority', 'due_date', 'created_at'];
$sortBy = in_array($sortBy, $allowedSort) ? $sortBy : 'created_at';
$sortOrder = strtoupper($sortOrder) === 'DESC' ? 'DESC' : 'ASC';

try {
    $sql = "SELECT * FROM tasks WHERE project_id = ?";
    $params = [$projectId];

    // Add filters
    if ($status && in_array($status, ['pending', 'working', 'stuck', 'completed'])) {
        $sql .= " AND status = ?";
        $params[] = $status;
    }

    if ($priority && in_array($priority, ['low', 'medium', 'high'])) {
        $sql .= " AND priority = ?";
        $params[] = $priority;
    }

    $sql .= " ORDER BY $sortBy $sortOrder";

    $stmt = $db->prepare($sql);
    $stmt->execute($params);
    $tasks = $stmt->fetchAll();

    jsonResponse([
        'success' => true,
        'tasks' => $tasks
    ]);
} catch (PDOException $e) {
    error_log("List Tasks Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to fetch tasks'], 500);
}
