<?php
require_once '../../includes/config.php';
require_once '../../includes/db.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

if ($_SERVER['REQUEST_METHOD'] !== 'DELETE' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'message' => 'Method not allowed'], 405);
}

$data = json_decode(file_get_contents('php://input'), true);
$urlId = intval($data['id'] ?? $_GET['id'] ?? 0);

if ($urlId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid URL ID']);
}

$userId = getCurrentUserId();
$db = getDB();

try {
    // Get URL and check ownership
    $stmt = $db->prepare("
        SELECT u.*, p.user_id
        FROM project_urls u
        JOIN projects p ON u.project_id = p.id
        WHERE u.id = ?
    ");
    $stmt->execute([$urlId]);
    $url = $stmt->fetch();

    if (!$url) {
        jsonResponse(['success' => false, 'message' => 'URL not found'], 404);
    }

    if ($url['user_id'] != $userId) {
        jsonResponse(['success' => false, 'message' => 'Unauthorized'], 403);
    }

    // Delete URL
    $stmt = $db->prepare("DELETE FROM project_urls WHERE id = ?");
    $stmt->execute([$urlId]);

    // Log activity
    logActivity($userId, 'delete_url', "Deleted URL: {$url['title']}", $url['project_id']);

    jsonResponse([
        'success' => true,
        'message' => 'URL deleted successfully'
    ]);
} catch (PDOException $e) {
    error_log("Delete URL Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to delete URL'], 500);
}
