<?php
require_once '../../includes/config.php';
require_once '../../includes/db.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 401);
}

$projectId = intval($_GET['project_id'] ?? 0);

if ($projectId <= 0) {
    jsonResponse(['success' => false, 'message' => 'Invalid project ID']);
}

$userId = getCurrentUserId();

// Check project ownership
if (!userOwnsProject($projectId, $userId)) {
    jsonResponse(['success' => false, 'message' => 'Unauthorized'], 403);
}

$db = getDB();

try {
    $stmt = $db->prepare("
        SELECT * FROM project_urls
        WHERE project_id = ?
        ORDER BY created_at DESC
    ");
    $stmt->execute([$projectId]);
    $urls = $stmt->fetchAll();

    jsonResponse([
        'success' => true,
        'urls' => $urls
    ]);
} catch (PDOException $e) {
    error_log("List URLs Error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Failed to fetch URLs'], 500);
}
