<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';
require_once 'includes/functions.php';

requireAuth();
$user = getCurrentUser();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Dashboard - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.2/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <!-- Top Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm sticky-top">
        <div class="container-fluid">
            <a class="navbar-brand fw-bold" href="dashboard.php">
                <i class="bi bi-clipboard-check-fill me-2"></i><?php echo APP_NAME; ?>
            </a>
            <div class="d-flex align-items-center">
                <a href="profile.php" class="navbar-text text-white me-3 d-none d-md-inline text-decoration-none">
                    <i class="bi bi-person-circle me-1"></i><?php echo e($user['username']); ?>
                </a>
                <a href="profile.php" class="btn btn-outline-light btn-sm me-2 d-none d-md-inline">
                    <i class="bi bi-gear"></i>
                </a>
                <a href="logout.php" class="btn btn-outline-light btn-sm">
                    <i class="bi bi-box-arrow-right"></i> <span class="d-none d-sm-inline">Logout</span>
                </a>
            </div>
        </div>
    </nav>

    <div class="container-fluid py-4">
        <!-- Stats Cards -->
        <div class="row g-3 mb-4" id="statsCards">
            <div class="col-6 col-md-3">
                <div class="card stat-card bg-primary text-white h-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <p class="mb-1 small">Total Projects</p>
                                <h2 class="mb-0" id="totalProjects">0</h2>
                            </div>
                            <i class="bi bi-folder-fill fs-2 opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="card stat-card bg-info text-white h-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <p class="mb-1 small">Working</p>
                                <h2 class="mb-0" id="workingProjects">0</h2>
                            </div>
                            <i class="bi bi-hourglass-split fs-2 opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="card stat-card bg-danger text-white h-100 shadow-sm" style="cursor: pointer;" onclick="showOverdueTasks()">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <p class="mb-1 small">Overdue Tasks</p>
                                <h2 class="mb-0" id="overdueTasks">0</h2>
                            </div>
                            <i class="bi bi-calendar-x fs-2 opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="card stat-card bg-success text-white h-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <p class="mb-1 small">Success</p>
                                <h2 class="mb-0" id="successProjects">0</h2>
                            </div>
                            <i class="bi bi-check-circle-fill fs-2 opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Search, Filter, and Create Button -->
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-4">
                        <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-search"></i></span>
                            <input type="text" class="form-control" id="searchInput" placeholder="Search projects...">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <select class="form-select" id="statusFilter">
                            <option value="">All Statuses</option>
                            <option value="working">Working</option>
                            <option value="stuck">Stuck</option>
                            <option value="success">Success</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select class="form-select" id="sortBy">
                            <option value="updated_at">Last Updated</option>
                            <option value="created_at">Date Created</option>
                            <option value="name">Name</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <button class="btn btn-primary w-100" data-bs-toggle="modal" data-bs-target="#createProjectModal">
                            <i class="bi bi-plus-circle-fill me-1"></i> New Project
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Projects List -->
        <div id="projectsList">
            <div class="text-center py-5">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Create/Edit Project Modal -->
    <div class="modal fade" id="createProjectModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="projectModalTitle">Create New Project</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="projectForm">
                        <input type="hidden" id="projectId">
                        <div class="mb-3">
                            <label for="projectName" class="form-label fw-semibold">Project Name *</label>
                            <input type="text" class="form-control form-control-lg" id="projectName" required>
                        </div>
                        <div class="mb-3">
                            <label for="projectDescription" class="form-label fw-semibold">Description</label>
                            <textarea class="form-control" id="projectDescription" rows="3"></textarea>
                        </div>
                        <div class="mb-3">
                            <label for="projectStatus" class="form-label fw-semibold">Status</label>
                            <select class="form-select form-select-lg" id="projectStatus">
                                <option value="working">Working</option>
                                <option value="stuck">Stuck</option>
                                <option value="success">Success</option>
                            </select>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary btn-lg" id="saveProjectBtn">
                        <i class="bi bi-check-circle-fill me-1"></i>Save Project
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title">Confirm Delete</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p class="mb-0">Are you sure you want to delete this project? This will also delete all tasks and documents associated with it. This action cannot be undone.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">
                        <i class="bi bi-trash-fill me-1"></i>Delete
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Overdue Tasks Modal -->
    <div class="modal fade" id="overdueTasksModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title">
                        <i class="bi bi-calendar-x me-2"></i>Overdue Tasks
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="overdueTasksContent">
                    <div class="text-center py-5">
                        <div class="spinner-border text-danger" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Bottom Navigation -->
    <nav class="mobile-bottom-nav d-md-none">
        <a href="dashboard.php" class="nav-item active">
            <i class="bi bi-house-fill"></i>
            <span>Dashboard</span>
        </a>
        <a href="#" class="nav-item" data-bs-toggle="modal" data-bs-target="#createProjectModal">
            <i class="bi bi-plus-circle-fill fs-2"></i>
            <span>Add</span>
        </a>
        <a href="profile.php" class="nav-item">
            <i class="bi bi-person-circle"></i>
            <span>Profile</span>
        </a>
    </nav>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
    <script src="assets/js/app.js?v=<?php echo time(); ?>"></script>
    <script src="assets/js/dashboard.js?v=<?php echo time(); ?>"></script>
</body>
</html>
