<?php
/**
 * Database Configuration
 * Project Management Application
 */

// Database credentials
define('DB_HOST', 'localhost');
define('DB_NAME', 'project_manager');
define('DB_USER', 'root');
define('DB_PASS', '');  // Default XAMPP MySQL password is empty
define('DB_CHARSET', 'utf8mb4');

// Application settings
define('APP_NAME', 'Project Manager');
define('APP_URL', 'http://localhost/Claude');
define('UPLOAD_DIR', __DIR__ . '/../assets/uploads/');
define('MAX_FILE_SIZE', 10485760); // 10MB in bytes
define('ALLOWED_FILE_TYPES', ['pdf', 'doc', 'docx', 'xls', 'xlsx', 'ppt', 'pptx', 'txt', 'jpg', 'jpeg', 'png', 'gif', 'zip', 'rar']);

// Session configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 0);  // Set to 1 if using HTTPS
session_start();

// Timezone
date_default_timezone_set('UTC');

// Error logging configuration
define('ERROR_LOG_FILE', __DIR__ . '/../logs/error.log');

// Enable error logging to file
error_reporting(E_ALL);
ini_set('display_errors', 1);  // Set to 0 in production
ini_set('log_errors', 1);
ini_set('error_log', ERROR_LOG_FILE);

// Custom error handler to log all errors
set_error_handler(function($errno, $errstr, $errfile, $errline) {
    $date = date('Y-m-d H:i:s');
    $error = "[$date] PHP Error ($errno): $errstr in $errfile on line $errline\n";
    error_log($error, 3, ERROR_LOG_FILE);

    // Display error if display_errors is on
    if (ini_get('display_errors')) {
        echo "<div style='background:#ffdddd;color:#d8000c;padding:10px;margin:10px;border:1px solid #d8000c;border-radius:5px;'>";
        echo "<strong>Error:</strong> $errstr<br>";
        echo "<strong>File:</strong> $errfile<br>";
        echo "<strong>Line:</strong> $errline";
        echo "</div>";
    }

    return false;
});

// Custom exception handler
set_exception_handler(function($exception) {
    $date = date('Y-m-d H:i:s');
    $error = "[$date] Uncaught Exception: " . $exception->getMessage() .
             " in " . $exception->getFile() .
             " on line " . $exception->getLine() . "\n" .
             "Stack trace:\n" . $exception->getTraceAsString() . "\n";
    error_log($error, 3, ERROR_LOG_FILE);

    if (ini_get('display_errors')) {
        echo "<div style='background:#ffdddd;color:#d8000c;padding:10px;margin:10px;border:1px solid #d8000c;border-radius:5px;'>";
        echo "<strong>Exception:</strong> " . $exception->getMessage() . "<br>";
        echo "<strong>File:</strong> " . $exception->getFile() . "<br>";
        echo "<strong>Line:</strong> " . $exception->getLine();
        echo "</div>";
    }
});

// Log script start
$logDate = date('Y-m-d H:i:s');
$logMsg = "[$logDate] Script: " . ($_SERVER['REQUEST_URI'] ?? 'CLI') . " | IP: " . ($_SERVER['REMOTE_ADDR'] ?? 'N/A') . "\n";
error_log($logMsg, 3, ERROR_LOG_FILE);
