<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';
require_once 'includes/functions.php';

requireAuth();
$user = getCurrentUser();

$projectId = intval($_GET['id'] ?? 0);
if ($projectId <= 0) {
    header('Location: dashboard.php');
    exit;
}

// Verify ownership
if (!userOwnsProject($projectId, $user['id'])) {
    header('Location: dashboard.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Project - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.2/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <!-- Top Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm sticky-top">
        <div class="container-fluid">
            <a class="navbar-brand fw-bold" href="dashboard.php">
                <i class="bi bi-arrow-left-circle me-2"></i>Back
            </a>
            <div class="d-flex align-items-center">
                <a href="accounts.php?project_id=<?php echo $projectId; ?>" class="btn btn-outline-light btn-sm me-2" id="accountsBtn">
                    <i class="bi bi-currency-dollar"></i> Accounts
                </a>
                <button class="btn btn-outline-danger btn-sm" id="deleteProjectBtn">
                    <i class="bi bi-trash-fill"></i>
                </button>
            </div>
        </div>
    </nav>

    <div class="container-fluid py-4">
        <!-- Project Header -->
        <div class="card shadow-sm mb-4" id="projectHeader">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start mb-3">
                    <div class="flex-grow-1">
                        <h2 class="mb-2" id="projectName">Loading...</h2>
                        <p class="text-muted mb-2" id="projectDescription"></p>
                        <span class="badge" id="projectStatusBadge"></span>
                    </div>
                </div>
                <div class="progress" style="height: 25px;">
                    <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar"
                         id="projectProgress" style="width: 0%">0%</div>
                </div>
                <small class="text-muted mt-2 d-block" id="projectProgressText"></small>
            </div>
        </div>

        <!-- Tabs -->
        <ul class="nav nav-tabs nav-fill mb-4" id="projectTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="tasks-tab" data-bs-toggle="tab" data-bs-target="#tasks"
                        type="button" role="tab">
                    <i class="bi bi-list-check"></i> Tasks
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="documents-tab" data-bs-toggle="tab" data-bs-target="#documents"
                        type="button" role="tab">
                    <i class="bi bi-file-earmark-text"></i> Documents
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="activity-tab" data-bs-toggle="tab" data-bs-target="#activity"
                        type="button" role="tab">
                    <i class="bi bi-clock-history"></i> Activity
                </button>
            </li>
        </ul>

        <div class="tab-content" id="projectTabContent">
            <!-- Tasks Tab -->
            <div class="tab-pane fade show active" id="tasks" role="tabpanel">
                <div class="mb-3">
                    <button class="btn btn-primary btn-lg w-100 w-md-auto" data-bs-toggle="modal" data-bs-target="#createTaskModal">
                        <i class="bi bi-plus-circle-fill me-2"></i>Add New Task
                    </button>
                </div>
                <div id="tasksList">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status"></div>
                    </div>
                </div>
            </div>

            <!-- Documents Tab -->
            <div class="tab-pane fade" id="documents" role="tabpanel">
                <!-- Notes Section -->
                <div class="card shadow-sm mb-3">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="bi bi-sticky"></i> Notes</h5>
                    </div>
                    <div class="card-body">
                        <form id="notesForm">
                            <div class="mb-3">
                                <textarea class="form-control" id="documentNotes" rows="5"
                                          placeholder="Add notes about documents, files, or anything related to this project..."></textarea>
                                <small class="text-muted">Add notes, instructions, or important information about documents</small>
                            </div>
                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-check-circle-fill me-2"></i>Save Notes
                            </button>
                        </form>
                    </div>
                </div>

                <!-- URLs Section -->
                <div class="card shadow-sm mb-3">
                    <div class="card-header bg-light d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="bi bi-link-45deg"></i> Useful Links</h5>
                        <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addUrlModal">
                            <i class="bi bi-plus-circle"></i> Add URL
                        </button>
                    </div>
                    <div class="card-body" id="urlsList">
                        <div class="text-center py-3">
                            <div class="spinner-border text-primary spinner-border-sm" role="status"></div>
                        </div>
                    </div>
                </div>

                <!-- Files Section -->
                <div class="card shadow-sm mb-3">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="bi bi-file-earmark-arrow-up"></i> Files</h5>
                    </div>
                    <div class="card-body">
                        <form id="uploadForm" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="fileInput" class="form-label fw-semibold">Upload Documents</label>
                                <input type="file" class="form-control form-control-lg" id="fileInput" name="files[]" multiple>
                                <small class="text-muted">Max 10MB per file. Allowed: PDF, DOC, XLS, images, ZIP</small>
                            </div>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-cloud-upload-fill me-2"></i>Upload Files
                            </button>
                        </form>
                    </div>
                </div>
                <div id="documentsList">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status"></div>
                    </div>
                </div>
            </div>

            <!-- Activity Tab -->
            <div class="tab-pane fade" id="activity" role="tabpanel">
                <div id="activityList">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Create/Edit Task Modal -->
    <div class="modal fade" id="createTaskModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="taskModalTitle">Create New Task</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="taskForm">
                        <input type="hidden" id="taskId">
                        <div class="mb-3">
                            <label for="taskTitle" class="form-label fw-semibold">Task Title *</label>
                            <input type="text" class="form-control form-control-lg" id="taskTitle" required>
                        </div>
                        <div class="mb-3">
                            <label for="taskDescription" class="form-label fw-semibold">Description</label>
                            <textarea class="form-control" id="taskDescription" rows="2"></textarea>
                        </div>
                        <div class="mb-3">
                            <label for="taskNotes" class="form-label fw-semibold">Notes</label>
                            <textarea class="form-control" id="taskNotes" rows="2"></textarea>
                        </div>
                        <div class="row g-3">
                            <div class="col-md-4">
                                <label for="taskStatus" class="form-label fw-semibold">Status</label>
                                <select class="form-select form-select-lg" id="taskStatus">
                                    <option value="pending">Pending</option>
                                    <option value="working">Working</option>
                                    <option value="stuck">Stuck</option>
                                    <option value="completed">Completed</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="taskPriority" class="form-label fw-semibold">Priority</label>
                                <select class="form-select form-select-lg" id="taskPriority">
                                    <option value="low">Low</option>
                                    <option value="medium" selected>Medium</option>
                                    <option value="high">High</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="taskDueDate" class="form-label fw-semibold">Due Date</label>
                                <input type="date" class="form-control form-control-lg" id="taskDueDate">
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary btn-lg" id="saveTaskBtn">
                        <i class="bi bi-check-circle-fill me-1"></i>Save Task
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Modals -->
    <div class="modal fade" id="deleteProjectModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title">Delete Project</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p class="mb-0">Are you sure? This will delete all tasks and documents. This action cannot be undone.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteProjectBtn">Delete</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="deleteTaskModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title">Delete Task</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p class="mb-0">Are you sure you want to delete this task?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteTaskBtn">Delete</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Add URL Modal -->
    <div class="modal fade" id="addUrlModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add URL Link</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="urlForm">
                        <div class="mb-3">
                            <label for="urlTitle" class="form-label fw-semibold">Title *</label>
                            <input type="text" class="form-control form-control-lg" id="urlTitle"
                                   placeholder="e.g., Design Mockups, API Documentation" required>
                            <div class="invalid-feedback">Please enter a title</div>
                        </div>
                        <div class="mb-3">
                            <label for="urlAddress" class="form-label fw-semibold">URL *</label>
                            <input type="url" class="form-control form-control-lg" id="urlAddress"
                                   placeholder="https://example.com" required>
                            <small class="text-muted d-block">Full URL including http:// or https://</small>
                            <div class="invalid-feedback">Please enter a valid URL</div>
                        </div>
                        <div class="mb-3">
                            <label for="urlDescription" class="form-label fw-semibold">Description</label>
                            <textarea class="form-control" id="urlDescription" rows="2"
                                      placeholder="Optional description"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary btn-lg" id="saveUrlBtn">
                        <i class="bi bi-plus-circle-fill me-1"></i>Add URL
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>const PROJECT_ID = <?php echo $projectId; ?>;</script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/app.js?v=<?php echo time(); ?>"></script>
    <script src="assets/js/project.js?v=<?php echo time(); ?>"></script>
    <script src="assets/js/project-notes-urls.js?v=<?php echo time(); ?>"></script>
</body>
</html>
