<?php
/**
 * Profile Setup - Add Name Field to Users Table
 * Run this once to add the name column
 */

require_once 'includes/config.php';
require_once 'includes/db.php';

$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_column'])) {
    try {
        $db = getDB();

        // Check if column already exists
        $stmt = $db->query("SHOW COLUMNS FROM users LIKE 'name'");
        if ($stmt->rowCount() > 0) {
            $message = "Name column already exists!";
            $messageType = "warning";
        } else {
            // Add name column
            $db->exec("ALTER TABLE users ADD COLUMN name VARCHAR(100) NULL AFTER username");
            $message = "Name column added successfully! You can now use the profile page.";
            $messageType = "success";
        }
    } catch (Exception $e) {
        $message = "Error: " . $e->getMessage();
        $messageType = "danger";
    }
}

// Check current status
try {
    $db = getDB();
    $stmt = $db->query("SHOW COLUMNS FROM users LIKE 'name'");
    $columnExists = $stmt->rowCount() > 0;
} catch (Exception $e) {
    $columnExists = false;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profile Setup - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.2/font/bootstrap-icons.css">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white">
                        <h4 class="mb-0"><i class="bi bi-gear-fill"></i> Profile Setup</h4>
                    </div>
                    <div class="card-body">
                        <h5>Add Name Field to Users Table</h5>
                        <p class="text-muted">This will add a "name" column to the users table, allowing users to set their full name in addition to their username.</p>

                        <?php if ($message): ?>
                            <div class="alert alert-<?php echo $messageType; ?> alert-dismissible fade show" role="alert">
                                <?php if ($messageType === 'success'): ?>
                                    <i class="bi bi-check-circle-fill"></i>
                                <?php elseif ($messageType === 'warning'): ?>
                                    <i class="bi bi-exclamation-triangle-fill"></i>
                                <?php else: ?>
                                    <i class="bi bi-x-circle-fill"></i>
                                <?php endif; ?>
                                <?php echo htmlspecialchars($message); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <div class="alert alert-info">
                            <strong><i class="bi bi-info-circle"></i> Current Status:</strong><br>
                            Name column: <?php echo $columnExists ? '<span class="badge bg-success">Already exists</span>' : '<span class="badge bg-warning">Not found</span>'; ?>
                        </div>

                        <?php if (!$columnExists): ?>
                            <form method="POST">
                                <div class="alert alert-warning">
                                    <strong>⚠️ Before proceeding:</strong>
                                    <ul class="mb-0">
                                        <li>Make sure you have a database backup</li>
                                        <li>This will modify the users table structure</li>
                                        <li>This operation is safe and reversible</li>
                                    </ul>
                                </div>

                                <button type="submit" name="add_column" class="btn btn-primary btn-lg w-100">
                                    <i class="bi bi-plus-circle-fill"></i> Add Name Column to Database
                                </button>
                            </form>
                        <?php else: ?>
                            <div class="alert alert-success">
                                <i class="bi bi-check-circle-fill"></i> Setup complete! The name column has been added to your database.
                            </div>

                            <a href="profile.php" class="btn btn-primary btn-lg w-100 mb-2">
                                <i class="bi bi-person-circle"></i> Go to Profile Page
                            </a>
                            <a href="dashboard.php" class="btn btn-secondary btn-lg w-100">
                                <i class="bi bi-house-fill"></i> Go to Dashboard
                            </a>
                        <?php endif; ?>

                        <hr class="my-4">

                        <h6>Alternative Method (Manual SQL):</h6>
                        <p class="small text-muted">You can also run this SQL in phpMyAdmin:</p>
                        <pre class="bg-dark text-light p-3 rounded"><code>ALTER TABLE users ADD COLUMN name VARCHAR(100) NULL AFTER username;</code></pre>

                        <div class="mt-3">
                            <a href="test-config.php" class="btn btn-sm btn-outline-secondary">
                                <i class="bi bi-gear"></i> Run Diagnostics
                            </a>
                            <a href="view-errors.php" class="btn btn-sm btn-outline-secondary">
                                <i class="bi bi-file-text"></i> View Error Log
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
