<?php
require_once 'includes/config.php';
require_once 'includes/db.php';

$db = getDB();

echo "<h2>Database Structure Check</h2>";

// Check document_notes column
echo "<h3>1. Projects Table - document_notes column:</h3>";
try {
    $stmt = $db->query("SHOW COLUMNS FROM projects LIKE 'document_notes'");
    $column = $stmt->fetch();
    if ($column) {
        echo "<pre>✅ Column exists: ";
        print_r($column);
        echo "</pre>";
    } else {
        echo "<p style='color:red'>❌ Column does NOT exist!</p>";
        echo "<p>Run this SQL: <code>ALTER TABLE projects ADD COLUMN document_notes TEXT NULL AFTER description;</code></p>";
    }
} catch (Exception $e) {
    echo "<p style='color:red'>Error: " . $e->getMessage() . "</p>";
}

// Check project_urls table
echo "<h3>2. project_urls Table:</h3>";
try {
    $stmt = $db->query("SHOW TABLES LIKE 'project_urls'");
    if ($stmt->rowCount() > 0) {
        echo "<p>✅ Table exists</p>";

        // Show structure
        $stmt = $db->query("DESCRIBE project_urls");
        echo "<pre>";
        print_r($stmt->fetchAll());
        echo "</pre>";
    } else {
        echo "<p style='color:red'>❌ Table does NOT exist!</p>";
        echo "<p>Run setup-documents.php or execute the SQL manually</p>";
    }
} catch (Exception $e) {
    echo "<p style='color:red'>Error: " . $e->getMessage() . "</p>";
}

// Test API endpoints
echo "<h3>3. API Endpoint Files Check:</h3>";
$apiFiles = [
    'api/projects/update-notes.php',
    'api/urls/create.php',
    'api/urls/list.php',
    'api/urls/delete.php'
];

foreach ($apiFiles as $file) {
    if (file_exists($file)) {
        echo "✅ $file exists<br>";
    } else {
        echo "<span style='color:red'>❌ $file NOT FOUND</span><br>";
    }
}

// Test JavaScript files
echo "<h3>4. JavaScript Files Check:</h3>";
$jsFiles = [
    'assets/js/app.js',
    'assets/js/project.js',
    'assets/js/project-notes-urls.js'
];

foreach ($jsFiles as $file) {
    if (file_exists($file)) {
        echo "✅ $file exists<br>";
    } else {
        echo "<span style='color:red'>❌ $file NOT FOUND</span><br>";
    }
}

echo "<hr>";
echo "<h3>Quick Fix:</h3>";
echo "<ol>";
echo "<li><a href='setup-documents.php'>Run setup-documents.php</a> if tables/columns are missing</li>";
echo "<li>Open browser console (F12) and check for JavaScript errors</li>";
echo "<li>Try saving notes/URLs and check <a href='view-errors.php'>error log</a></li>";
echo "<li>Go to a <a href='dashboard.php'>project</a> and try the Documents tab</li>";
echo "</ol>";
?>
