<?php
session_start();
require_once 'includes/config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';

// Check if user is logged in
if (!isLoggedIn()) {
    die('Please log in first');
}

$userId = getCurrentUserId();
$db = getDB();

echo "<h2>Overdue Tasks Debug</h2>";
echo "<p>User ID: $userId</p>";
echo "<p>Current Server Date: " . date('Y-m-d H:i:s') . "</p>";
echo "<hr>";

// Test the overdue count query
$stmt = $db->prepare("
    SELECT COUNT(*) as overdue
    FROM tasks t
    JOIN projects p ON t.project_id = p.id
    WHERE p.user_id = ?
    AND t.status != 'completed'
    AND t.due_date IS NOT NULL
    AND t.due_date < CURDATE()
");
$stmt->execute([$userId]);
$overdueData = $stmt->fetch();

echo "<h3>Overdue Count from Database:</h3>";
echo "<pre>";
var_dump($overdueData);
echo "</pre>";

// Get actual overdue tasks details
$stmt = $db->prepare("
    SELECT
        t.id,
        t.title,
        t.status,
        t.due_date,
        p.name as project_name,
        CURDATE() as today,
        DATEDIFF(CURDATE(), t.due_date) as days_overdue
    FROM tasks t
    JOIN projects p ON t.project_id = p.id
    WHERE p.user_id = ?
    AND t.status != 'completed'
    AND t.due_date IS NOT NULL
    AND t.due_date < CURDATE()
");
$stmt->execute([$userId]);
$overdueTasks = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<h3>Overdue Tasks Details:</h3>";
echo "<pre>";
print_r($overdueTasks);
echo "</pre>";

// Get ALL tasks with due dates for comparison
$stmt = $db->prepare("
    SELECT
        t.id,
        t.title,
        t.status,
        t.due_date,
        p.name as project_name,
        CURDATE() as today,
        CASE
            WHEN t.due_date < CURDATE() THEN 'OVERDUE'
            WHEN t.due_date = CURDATE() THEN 'DUE TODAY'
            ELSE 'FUTURE'
        END as due_status
    FROM tasks t
    JOIN projects p ON t.project_id = p.id
    WHERE p.user_id = ?
    AND t.due_date IS NOT NULL
    ORDER BY t.due_date
");
$stmt->execute([$userId]);
$allTasks = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<h3>All Tasks with Due Dates:</h3>";
echo "<pre>";
print_r($allTasks);
echo "</pre>";

echo "<hr>";
echo "<p><a href='dashboard.php'>← Back to Dashboard</a></p>";
